/*
 * Decompiled with CFR 0.152.
 */
package com.biz.api.controllers;

import com.biz.api.dtos.CompteResponseDto;
import com.biz.api.dtos.LoginInfoDto;
import com.biz.api.dtos.NouveauCompteDto;
import com.biz.api.dtos.UserInfoResponse;
import com.biz.api.services.CompteService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"api/v1"})
@CrossOrigin(origins={"http://localhost"}, allowCredentials="true", allowedHeaders={"*"}, methods={RequestMethod.GET, RequestMethod.POST, RequestMethod.DELETE, RequestMethod.PUT, RequestMethod.OPTIONS})
public class CompteController {
    @Autowired
    private CompteService compteService;

    @PostMapping(value={"/compte/verifcodesecret"})
    public Boolean VerirfierCodePinActuel(@RequestParam(value="compteid") String compteid, @RequestParam(value="oldpin") String oldpin) {
        return this.compteService.VerirfierCodePinActuel(Long.valueOf(compteid), oldpin);
    }

    @GetMapping(value={"compte/qrcode/{fileName}"})
    public String getCurrentUserQRCodeBase64(@PathVariable(value="fileName") String fileName) {
        return this.compteService.getCurrentUserQRCodeBase64(fileName);
    }

    @PutMapping(value={"/compte/updatecodesecret"})
    public ResponseEntity<CompteResponseDto> UpdateCodePinActuel(@RequestParam(value="compteid") String compteid, @RequestParam(value="newpin") String newpin) {
        return this.compteService.UpdateCodePinActuel(Long.valueOf(compteid), newpin);
    }

    @PostMapping(value={"/compte/new"})
    public ResponseEntity<UserInfoResponse> CreerCompteClient(@Validated @RequestBody NouveauCompteDto nouveauCompteDto) {
        return this.compteService.CreerCompteClient(nouveauCompteDto);
    }

    @PostMapping(value={"/compte/veriftel"})
    public Boolean VerifTelephone(@RequestParam(value="telephone") String telephone) {
        return this.compteService.VerifTelephone(telephone);
    }

    @PostMapping(value={"/compte/login"})
    public ResponseEntity<UserInfoResponse> ConnecterClient(@Validated @RequestBody LoginInfoDto loginInfoDto) {
        return this.compteService.ConnecterClient(loginInfoDto);
    }
}

