/*
 * Decompiled with CFR 0.152.
 */
package com.biz.api.controllers;

import com.biz.api.dtos.NouvelleTransactionDto;
import com.biz.api.dtos.TransactionDtoWithPages;
import com.biz.api.dtos.TransactionResponse;
import com.biz.api.services.TransactionService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"api/v1/transaction"})
@CrossOrigin(origins={"http://localhost"}, allowCredentials="true", allowedHeaders={"*"}, methods={RequestMethod.GET, RequestMethod.POST, RequestMethod.DELETE, RequestMethod.PUT, RequestMethod.OPTIONS})
public class TransactionController {
    @Autowired
    private TransactionService transactionService;

    @PostMapping(value={"/accueilcompte"})
    public ResponseEntity<TransactionDtoWithPages> GetTransactionsAccueilByCompteId(@RequestParam(value="id") String id) {
        return this.transactionService.GetTransactionsAccueilByCompteId(Long.valueOf(id));
    }

    @PostMapping(value={"/allbycompte"})
    public ResponseEntity<TransactionDtoWithPages> GetAllTransactionsByCompteId(@RequestParam(value="id") String id) {
        return this.transactionService.GetAllTransactionsByCompteId(Long.valueOf(id));
    }

    @PostMapping(value={"/ajouter"})
    public ResponseEntity<TransactionResponse> AjouterTransaction(@Validated @RequestBody NouvelleTransactionDto nouvelleTransactionDto) {
        return this.transactionService.AjouterTransaction(nouvelleTransactionDto);
    }

    @PostMapping(value={"/depot"})
    public String fairedepot(@RequestParam(value="agentid") String agentid, @RequestParam(value="telephoneclient") String telephoneclient, @RequestParam(value="montant") String montant) {
        return this.transactionService.fairedepot(Long.valueOf(agentid), telephoneclient, Double.valueOf(montant));
    }

    @PostMapping(value={"/retrait"})
    public String faireretrait(@RequestParam(value="agentid") String agentid, @RequestParam(value="telephoneclient") String telephoneclient, @RequestParam(value="montant") String montant) {
        return this.transactionService.faireretrait(Long.valueOf(agentid), telephoneclient, Double.valueOf(montant));
    }
}

