/*
 * Decompiled with CFR 0.152.
 */
package com.biz.api.crypto;

import com.biz.api.services.EncryptionService;
import jakarta.persistence.AttributeConverter;

public class EncryptedEmailConverter
implements AttributeConverter<String, String> {
    private final EncryptionService encryptionService;

    public EncryptedEmailConverter(EncryptionService encryptionService) {
        this.encryptionService = encryptionService;
    }

    public String convertToDatabaseColumn(String email) {
        if (email != null && !email.matches("^[A-Za-z0-9+_.-]+@[A-Za-z0-9.-]+\\.[A-Za-z]{2,}$")) {
            throw new IllegalArgumentException("Invalid email format: " + email);
        }
        return this.encryptionService.encrypt(email);
    }

    public String convertToEntityAttribute(String dbData) {
        return this.encryptionService.decrypt(dbData);
    }
}

