/*
 * Decompiled with CFR 0.152.
 */
package com.biz.api.services;

import com.biz.api.dtos.AgentAdminDtoWithPages;
import com.biz.api.dtos.NouvelAgentDto;
import com.biz.api.entities.Agent;
import com.biz.api.mapstruct.AgentMapper;
import com.biz.api.repositories.AgentRepository;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AgentService {
    @Autowired
    private AgentRepository agentRepository;
    @Autowired
    private AgentMapper agentMapper;
    @Autowired
    private ObjectMapper mapper;

    @Transactional
    public ResponseEntity<AgentAdminDtoWithPages> AjouterAgent(NouvelAgentDto nouvelAgentDto) {
        if (nouvelAgentDto == null) {
            return ResponseEntity.badRequest().build();
        }
        Agent agent = this.agentMapper.NouvelAgentDtoToAgent(nouvelAgentDto);
        agent.setEstbloquer(Boolean.valueOf(false));
        this.agentRepository.save((Object)agent);
        return this.ListerAgents(0);
    }

    public ResponseEntity<AgentAdminDtoWithPages> ListerAgents(int pagenumber) {
        if (pagenumber < 0) {
            return ResponseEntity.badRequest().build();
        }
        PageRequest pagerequest = PageRequest.of((int)pagenumber, (int)20);
        Page agentPage = this.agentRepository.findAllByOrderByDateCreationDesc((Pageable)pagerequest);
        AgentAdminDtoWithPages agentAdminDtoWithPages = new AgentAdminDtoWithPages();
        if (agentPage.hasContent()) {
            List agents = agentPage.getContent();
            agentAdminDtoWithPages.setAgentAdminDtos(this.agentMapper.AgentsToAgentAdminDtos(agents));
            agentAdminDtoWithPages.setTotalelements(agentPage.getTotalElements());
            agentAdminDtoWithPages.setTotalpages(agentPage.getTotalPages());
        }
        return ResponseEntity.ok((Object)agentAdminDtoWithPages);
    }

    @Transactional
    public ResponseEntity<AgentAdminDtoWithPages> bloquerAgent(Long id, int pagenumber) {
        if (id <= 0L || pagenumber < 0) {
            return ResponseEntity.badRequest().build();
        }
        Optional agentOpt = this.agentRepository.findById((Object)id);
        if (agentOpt.isEmpty()) {
            return ResponseEntity.badRequest().build();
        }
        Agent agent = (Agent)agentOpt.get();
        agent.setEstbloquer(Boolean.valueOf(true));
        this.agentRepository.save((Object)agent);
        return this.ListerAgents(pagenumber);
    }
}

