/*
 * Decompiled with CFR 0.152.
 */
package com.biz.api.services;

import com.biz.api.config.ConstanteConfig;
import com.biz.api.dtos.CompteResponseDto;
import com.biz.api.dtos.LoginInfoDto;
import com.biz.api.dtos.NouveauCompteDto;
import com.biz.api.dtos.UserInfoResponse;
import com.biz.api.entities.Compte;
import com.biz.api.entities.Connexion;
import com.biz.api.mapstruct.CompteMapper;
import com.biz.api.repositories.CompteRepository;
import com.biz.api.services.ConnexionService;
import com.biz.api.services.QRCodeService;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.persistence.EntityNotFoundException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.SecureRandom;
import java.time.LocalDateTime;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CompteService {
    @Autowired
    private QRCodeService qrCodeService;
    @Autowired
    private CompteRepository compteRepository;
    @Autowired
    private ObjectMapper mapper;
    @Autowired
    private CompteMapper compteMapper;
    @Autowired
    private BCryptPasswordEncoder bCryptPasswordEncoder;
    @Autowired
    private ConnexionService connexionService;
    private static final String PREFIX = "BIZ";
    private static final String CHARACTERS = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ";

    @Transactional
    public void GenererQRcodes() {
        List comptes = this.compteRepository.findAll();
        for (Compte compte : comptes) {
            try {
                compte.setQrcode(this.generateAndSaveQRCode(compte.getId()));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        this.compteRepository.saveAll((Iterable)comptes);
    }

    public byte[] generateCompteQRCode(Long compteId) throws Exception {
        Compte compte = (Compte)this.compteRepository.findById((Object)compteId).orElseThrow(() -> new EntityNotFoundException("Compte non trouv\u00e9"));
        String qrContent = this.buildQRContent(compte);
        return this.qrCodeService.generateQRCodeBlackTransparent(qrContent);
    }

    private String buildQRContent(Compte compte) {
        return String.format("{\n    \"type\": \"BIZ_ACCOUNT\",\n    \"accountId\": \"%s\",\n    \"phoneNumber\": \"%s\",\n    \"accountName\": \"%s\",\n    \"timestamp\": \"%s\"\n}\n", compte.getId(), compte.getTelephone(), compte.getNomcomplet(), System.currentTimeMillis());
    }

    @Transactional
    public String generateAndSaveQRCode(Long compteId) throws Exception {
        byte[] qrCodeBytes = this.generateCompteQRCode(compteId);
        String fileName = String.format("qr_compte_%d_%d.png", compteId, System.currentTimeMillis());
        String filePath = this.saveQRCodeFile(qrCodeBytes, fileName);
        Compte compte = (Compte)this.compteRepository.findById((Object)compteId).orElseThrow();
        compte.setQrcode(filePath);
        this.compteRepository.save((Object)compte);
        return filePath;
    }

    private String saveQRCodeFile(byte[] qrCodeBytes, String fileName) throws IOException {
        String uploadDir = "/home/biz/public_html/QrCodes/";
        File directory = new File(uploadDir);
        if (!directory.exists()) {
            directory.mkdirs();
        }
        String filePath = uploadDir + fileName;
        try (FileOutputStream fos = new FileOutputStream(filePath);){
            fos.write(qrCodeBytes);
        }
        return fileName;
    }

    private String GenererCodeParrainage() {
        StringBuilder code = new StringBuilder();
        code.append(PREFIX);
        SecureRandom random = new SecureRandom();
        for (int i = 0; i < 8; ++i) {
            code.append(CHARACTERS.charAt(random.nextInt(CHARACTERS.length())));
        }
        return code.toString();
    }

    public String generateUniqueCodeParrainage() {
        String code;
        while (this.compteRepository.existsByCodeparrainage(code = this.GenererCodeParrainage()).booleanValue()) {
        }
        return code;
    }

    @Transactional
    public ResponseEntity<UserInfoResponse> CreerCompteClient(NouveauCompteDto nouveauCompteDto) {
        if (nouveauCompteDto == null) {
            return null;
        }
        if (this.compteRepository.existsByTelephone(nouveauCompteDto.getTelephone()).booleanValue()) {
            return null;
        }
        Compte compte = this.compteMapper.NouveauCompteDtoToCompte(nouveauCompteDto);
        compte.setTypecompte("client");
        compte.setCreerparcodeparrainagetraiter(Boolean.valueOf(false));
        compte.setSolde(Double.valueOf(0.0));
        compte.setTransfertmensuel(Double.valueOf(0.0));
        compte.setTransfertquotidien(Double.valueOf(0.0));
        compte.setPlafondsolde(ConstanteConfig.plafondsolde);
        compte.setPlafondtransfertmensuel(ConstanteConfig.plafondtransfertmensuel);
        compte.setPlafondtransfertquotidien(ConstanteConfig.plafondtransfertquotidien);
        compte.setCodesecret(this.bCryptPasswordEncoder.encode((CharSequence)compte.getCodesecret()));
        compte.setCodeparrainage(this.generateUniqueCodeParrainage());
        Compte compte1 = (Compte)this.compteRepository.save((Object)compte);
        try {
            compte1.setQrcode(this.generateAndSaveQRCode(compte1.getId()));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        Compte compte2 = (Compte)this.compteRepository.save((Object)compte1);
        Connexion connexion = new Connexion();
        connexion.setStatus("connect\u00e9");
        connexion.setDebutsession(LocalDateTime.now());
        Connexion connexion1 = this.connexionService.SaveConnexion(connexion);
        UserInfoResponse userInfoResponse = new UserInfoResponse();
        userInfoResponse.setCompte(this.compteMapper.CompteToCompteResponseDto(compte2));
        userInfoResponse.setConnexionid(connexion1.getId());
        return ResponseEntity.ok((Object)userInfoResponse);
    }

    public String getCurrentUserQRCodeBase64(String fileName) {
        return this.qrCodeService.getQRCodeBase64FromFile(fileName);
    }

    public Boolean VerifTelephone(String telephone) {
        return this.compteRepository.existsByTelephone(telephone);
    }

    @Transactional
    public ResponseEntity<UserInfoResponse> ConnecterClient(LoginInfoDto loginInfoDto) {
        if (loginInfoDto == null) {
            return null;
        }
        Compte compte = this.compteRepository.findByTelephone(loginInfoDto.getTelephone());
        Connexion connexion = new Connexion();
        if (compte == null) {
            connexion.setStatus("t\u00e9l\u00e9phone incorrect");
            this.connexionService.SaveConnexion(connexion);
            return null;
        }
        if (!this.bCryptPasswordEncoder.matches((CharSequence)loginInfoDto.getCodesecret(), compte.getCodesecret())) {
            connexion.setStatus("code secret incorrect");
            this.connexionService.SaveConnexion(connexion);
            return null;
        }
        connexion.setStatus("connect\u00e9");
        connexion.setDebutsession(LocalDateTime.now());
        Connexion connexion1 = this.connexionService.SaveConnexion(connexion);
        UserInfoResponse userInfoResponse = new UserInfoResponse();
        userInfoResponse.setCompte(this.compteMapper.CompteToCompteResponseDto(compte));
        userInfoResponse.setConnexionid(connexion1.getId());
        return ResponseEntity.ok((Object)userInfoResponse);
    }

    public Boolean VerirfierCodePinActuel(Long compteid, String oldpin) {
        if (compteid == null || compteid <= 0L || oldpin == null || oldpin.length() != 4) {
            return ResponseEntity.badRequest().build().hasBody();
        }
        Compte compte = (Compte)this.compteRepository.findById((Object)compteid).orElseThrow();
        return this.bCryptPasswordEncoder.matches((CharSequence)oldpin, compte.getCodesecret());
    }

    @Transactional
    public ResponseEntity<CompteResponseDto> UpdateCodePinActuel(Long compteid, String newpin) {
        if (compteid == null || compteid <= 0L || newpin == null || newpin.length() != 4) {
            return ResponseEntity.badRequest().build();
        }
        Compte compte = (Compte)this.compteRepository.findById((Object)compteid).orElseThrow();
        compte.setCodesecret(this.bCryptPasswordEncoder.encode((CharSequence)newpin));
        Compte compte1 = (Compte)this.compteRepository.save((Object)compte);
        return ResponseEntity.ok((Object)this.compteMapper.CompteToCompteResponseDto(compte1));
    }
}

