/*
 * Decompiled with CFR 0.152.
 */
package com.biz.api.services;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.WriterException;
import com.google.zxing.client.j2se.MatrixToImageConfig;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.QRCodeWriter;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.util.Base64;
import java.util.HashMap;
import javax.imageio.ImageIO;
import org.springframework.core.io.ClassPathResource;
import org.springframework.stereotype.Service;

@Service
public class QRCodeService {
    private static final int QR_CODE_SIZE = 400;
    private static final int LOGO_SIZE = 80;
    private static final String LOGO_PATH = "static/images/biz_logo.png";
    public static final String QRCode_PATH = "/home/biz/public_html/QrCodes/";

    private MatrixToImageConfig getMatrixConfigBlackTransparent() {
        int black = -16777216;
        int transparent = 0xFFFFFF;
        return new MatrixToImageConfig(black, transparent);
    }

    public String getQRCodeBase64FromFile(String filename) {
        try {
            String qrCodePath = QRCode_PATH + filename;
            File qrCodeFile = new File(qrCodePath);
            if (!qrCodeFile.exists()) {
                System.out.printf("Fichier QR code introuvable: " + qrCodePath, new Object[0]);
                return null;
            }
            byte[] fileBytes = Files.readAllBytes(qrCodeFile.toPath());
            return Base64.getEncoder().encodeToString(fileBytes);
        }
        catch (Exception e) {
            System.err.println("Erreur lecture QR code");
            return null;
        }
    }

    public byte[] generateQRCodeBlackTransparent(String qrContent) throws Exception {
        BitMatrix bitMatrix = this.generateQRCodeMatrix(qrContent);
        BufferedImage qrImage = MatrixToImageWriter.toBufferedImage((BitMatrix)bitMatrix, (MatrixToImageConfig)this.getMatrixConfigBlackTransparent());
        BufferedImage logoImage = this.loadBizLogo();
        BufferedImage resizedLogo = this.resizeImage(logoImage, 80, 80);
        BufferedImage finalImage = this.overlayLogoTransparent(qrImage, resizedLogo);
        return this.imageToByteArray(finalImage);
    }

    private BufferedImage overlayLogoTransparent(BufferedImage qrImage, BufferedImage logoImage) {
        BufferedImage combined = new BufferedImage(400, 400, 2);
        Graphics2D graphics = combined.createGraphics();
        graphics.drawImage((Image)qrImage, 0, 0, null);
        int x = 160;
        int y = 160;
        graphics.drawImage((Image)logoImage, x, y, null);
        graphics.dispose();
        return combined;
    }

    private BufferedImage colorizeImage(BufferedImage originalImage, int color) {
        BufferedImage colorizedImage = new BufferedImage(originalImage.getWidth(), originalImage.getHeight(), 2);
        Graphics2D graphics = colorizedImage.createGraphics();
        graphics.drawImage((Image)originalImage, 0, 0, null);
        graphics.setComposite(AlphaComposite.SrcAtop);
        graphics.setColor(new Color(color));
        graphics.fillRect(0, 0, originalImage.getWidth(), originalImage.getHeight());
        graphics.dispose();
        return colorizedImage;
    }

    private BitMatrix generateQRCodeMatrix(String content) throws WriterException {
        QRCodeWriter qrCodeWriter = new QRCodeWriter();
        HashMap<EncodeHintType, Object> hints = new HashMap<EncodeHintType, Object>();
        hints.put(EncodeHintType.ERROR_CORRECTION, ErrorCorrectionLevel.H);
        hints.put(EncodeHintType.CHARACTER_SET, "UTF-8");
        hints.put(EncodeHintType.MARGIN, 1);
        return qrCodeWriter.encode(content, BarcodeFormat.QR_CODE, 400, 400, hints);
    }

    private BufferedImage loadBizLogo() throws IOException {
        ClassPathResource resource = new ClassPathResource(LOGO_PATH);
        try (InputStream inputStream = resource.getInputStream();){
            BufferedImage bufferedImage = ImageIO.read(inputStream);
            return bufferedImage;
        }
    }

    private BufferedImage resizeImage(BufferedImage originalImage, int width, int height) {
        BufferedImage resizedImage = new BufferedImage(width, height, 2);
        Graphics2D graphics = resizedImage.createGraphics();
        graphics.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        graphics.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics.drawImage(originalImage, 0, 0, width, height, null);
        graphics.dispose();
        return resizedImage;
    }

    private byte[] imageToByteArray(BufferedImage image) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)image, "PNG", baos);
        return baos.toByteArray();
    }
}

