/*
 * Decompiled with CFR 0.152.
 */
package com.biz.api.services;

import com.biz.api.repositories.TransactionRepository;
import java.security.SecureRandom;
import java.time.LocalDate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TransactionIdService {
    private static final String PREFIX = "BZ";
    private static final String CHARACTERS = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    @Autowired
    private TransactionRepository transactionRepository;

    public String generateUniqueId() {
        String id;
        while (this.transactionRepository.existsById((Object)(id = this.generateId()))) {
        }
        return id;
    }

    private String generateId() {
        StringBuilder id = new StringBuilder();
        id.append(PREFIX);
        LocalDate today = LocalDate.now();
        id.append(String.format("%02d%02d%02d", today.getYear() % 100, today.getMonthValue(), today.getDayOfMonth()));
        SecureRandom random = new SecureRandom();
        for (int i = 0; i < 10; ++i) {
            id.append(CHARACTERS.charAt(random.nextInt(CHARACTERS.length())));
        }
        return id.toString();
    }
}

