/*
 * Decompiled with CFR 0.152.
 */
package com.biz.api.services;

import com.biz.api.dtos.NouvelleTransactionDto;
import com.biz.api.dtos.TransactionDtoWithPages;
import com.biz.api.dtos.TransactionResponse;
import com.biz.api.entities.Agent;
import com.biz.api.entities.Compte;
import com.biz.api.entities.Transaction;
import com.biz.api.mapstruct.CompteMapper;
import com.biz.api.mapstruct.TransactionMapper;
import com.biz.api.repositories.AgentRepository;
import com.biz.api.repositories.CompteRepository;
import com.biz.api.repositories.TransactionRepository;
import com.biz.api.services.TransactionIdService;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TransactionService {
    @Autowired
    private TransactionRepository transactionRepository;
    @Autowired
    private TransactionMapper transactionMapper;
    @Autowired
    private CompteRepository compteRepository;
    @Autowired
    private CompteMapper compteMapper;
    @Autowired
    private TransactionIdService transactionIdService;
    @Autowired
    private AgentRepository agentRepository;

    public ResponseEntity<TransactionDtoWithPages> GetTransactionsAccueilByCompteId(Long id) {
        if (id == null) {
            return ResponseEntity.badRequest().build();
        }
        TransactionDtoWithPages transactionDtoWithPages = new TransactionDtoWithPages();
        PageRequest pageable = PageRequest.of((int)0, (int)20);
        Page transactionPage = this.transactionRepository.findByExpediteuridOrDestinataireidOrderByDateCreationDesc(id, id, (Pageable)pageable);
        if (!transactionPage.hasContent()) {
            return ResponseEntity.ok((Object)transactionDtoWithPages);
        }
        List transactionList = transactionPage.getContent();
        transactionDtoWithPages.setTransactions(this.transactionMapper.TransactionsToTransactionDtos(transactionList));
        transactionDtoWithPages.setTotalelements(transactionPage.getTotalElements());
        transactionDtoWithPages.setTotalpages(transactionPage.getTotalPages());
        Optional compteOptional = this.compteRepository.findById((Object)id);
        if (compteOptional.isEmpty()) {
            return ResponseEntity.badRequest().build();
        }
        Compte compte = (Compte)compteOptional.get();
        transactionDtoWithPages.setSoldecompte(compte.getSolde());
        return ResponseEntity.ok((Object)transactionDtoWithPages);
    }

    public ResponseEntity<TransactionDtoWithPages> GetAllTransactionsByCompteId(Long id) {
        if (id == null) {
            return ResponseEntity.badRequest().build();
        }
        TransactionDtoWithPages transactionDtoWithPages = new TransactionDtoWithPages();
        PageRequest pageable = PageRequest.of((int)0, (int)50);
        Page transactionPage = this.transactionRepository.findByExpediteuridOrDestinataireidOrderByDateCreationDesc(id, id, (Pageable)pageable);
        if (!transactionPage.hasContent()) {
            return ResponseEntity.ok((Object)transactionDtoWithPages);
        }
        List transactionList = transactionPage.getContent();
        transactionDtoWithPages.setTransactions(this.transactionMapper.TransactionsToTransactionDtos(transactionList));
        transactionDtoWithPages.setTotalelements(transactionPage.getTotalElements());
        transactionDtoWithPages.setTotalpages(transactionPage.getTotalPages());
        return ResponseEntity.ok((Object)transactionDtoWithPages);
    }

    @Transactional
    public ResponseEntity<TransactionResponse> AjouterTransaction(NouvelleTransactionDto nouvelleTransactionDto) {
        if (nouvelleTransactionDto == null || nouvelleTransactionDto.getExpediteurid() == null || nouvelleTransactionDto.getExpediteurid() <= 0L || nouvelleTransactionDto.getMontantenvoyer() <= 0.0 || nouvelleTransactionDto.getTelephoneDestinataire() == null || nouvelleTransactionDto.getTelephoneDestinataire().equals("")) {
            return ResponseEntity.badRequest().build();
        }
        TransactionResponse transactionResponse = new TransactionResponse();
        Transaction transaction = this.transactionMapper.NouvelleTransactionDtoToTransaction(nouvelleTransactionDto);
        Compte comptedestinataire = this.compteRepository.findByTelephone(transaction.getTelephoneDestinataire());
        if (comptedestinataire == null) {
            transactionResponse.setMessage("ce num\u00e9ro n'existe pas");
            return ResponseEntity.ok((Object)transactionResponse);
        }
        if (comptedestinataire.getSolde() + transaction.getMontantrecu() > comptedestinataire.getPlafondsolde()) {
            transactionResponse.setMessage("plafond solde destinataire");
            return ResponseEntity.ok((Object)transactionResponse);
        }
        transaction.setId(this.transactionIdService.generateUniqueId());
        transaction.setDestinataireid(comptedestinataire.getId());
        transaction.setNomdestinataire(comptedestinataire.getNomcomplet());
        transaction.setStatus("success");
        this.transactionRepository.save((Object)transaction);
        comptedestinataire.setSolde(Double.valueOf(comptedestinataire.getSolde() + transaction.getMontantrecu()));
        this.compteRepository.save((Object)comptedestinataire);
        Optional compteexpediteurOpt = this.compteRepository.findById((Object)transaction.getExpediteurid());
        if (compteexpediteurOpt.isEmpty()) {
            return ResponseEntity.badRequest().build();
        }
        Compte compteexpediteur = (Compte)compteexpediteurOpt.get();
        compteexpediteur.setSolde(Double.valueOf(compteexpediteur.getSolde() - transaction.getMontantenvoyer()));
        compteexpediteur.setTransfertquotidien(Double.valueOf(compteexpediteur.getTransfertquotidien() + transaction.getMontantenvoyer()));
        compteexpediteur.setTransfertmensuel(Double.valueOf(compteexpediteur.getTransfertmensuel() + transaction.getMontantenvoyer()));
        Compte compte = (Compte)this.compteRepository.save((Object)compteexpediteur);
        transactionResponse.setMessage("success");
        transactionResponse.setCompte(this.compteMapper.CompteToCompteResponseDto(compte));
        return ResponseEntity.ok((Object)transactionResponse);
    }

    @Transactional
    public String fairedepot(Long agentid, String telephoneclient, Double montant) {
        if (agentid <= 0L || telephoneclient == null || telephoneclient.equals("") || montant == null || montant.isNaN() || montant.isInfinite()) {
            return ResponseEntity.badRequest().build().toString();
        }
        Compte client = this.compteRepository.findByTelephone(telephoneclient);
        Optional agentOpt = this.agentRepository.findById((Object)agentid);
        if (client == null || agentOpt.isEmpty()) {
            return ResponseEntity.badRequest().build().toString();
        }
        if (client.getSolde() + montant > client.getPlafondsolde()) {
            return "solde client d\u00e9pass\u00e9";
        }
        Agent agent = (Agent)agentOpt.get();
        if (montant > agent.getSolde()) {
            return "solde agent insuffisant";
        }
        Transaction transaction = new Transaction();
        transaction.setNomdestinataire(client.getNomcomplet());
        transaction.setDestinataireid(client.getId());
        transaction.setAgentid(agentid);
        transaction.setExpediteurid(agentid);
        transaction.setMontantenvoyer(montant);
        transaction.setMontantrecu(montant);
        transaction.setTelephoneDestinataire(telephoneclient);
        transaction.setNomexpediteur(agent.getNomcomplet());
        transaction.setTelephoneExpediteur(agent.getTelephone());
        transaction.setTypedetransaction("d\u00e9pot");
        transaction.setStatus("success");
        client.setSolde(Double.valueOf(client.getSolde() + montant));
        agent.setSolde(Double.valueOf(agent.getSolde() - montant));
        this.transactionRepository.save((Object)transaction);
        this.compteRepository.save((Object)client);
        this.agentRepository.save((Object)agent);
        return "d\u00e9pot r\u00e9ussi";
    }

    @Transactional
    public String faireretrait(Long agentid, String telephoneclient, Double montant) {
        if (agentid <= 0L || telephoneclient == null || telephoneclient.equals("") || montant == null || montant.isNaN() || montant.isInfinite()) {
            return ResponseEntity.badRequest().build().toString();
        }
        Compte client = this.compteRepository.findByTelephone(telephoneclient);
        Optional agentOpt = this.agentRepository.findById((Object)agentid);
        if (client == null || agentOpt.isEmpty()) {
            return ResponseEntity.badRequest().build().toString();
        }
        if (montant > client.getSolde()) {
            return "montant sup\u00e9rieur au solde client";
        }
        Agent agent = (Agent)agentOpt.get();
        Transaction transaction = new Transaction();
        transaction.setNomdestinataire(agent.getNomcomplet());
        transaction.setDestinataireid(agent.getId());
        transaction.setAgentid(agentid);
        transaction.setExpediteurid(client.getId());
        transaction.setMontantenvoyer(montant);
        transaction.setMontantrecu(montant);
        transaction.setTelephoneDestinataire(agent.getTelephone());
        transaction.setNomexpediteur(client.getNomcomplet());
        transaction.setTelephoneExpediteur(client.getTelephone());
        transaction.setTypedetransaction("retrait");
        transaction.setStatus("success");
        client.setSolde(Double.valueOf(client.getSolde() - montant));
        agent.setSolde(Double.valueOf(agent.getSolde() + montant));
        this.transactionRepository.save((Object)transaction);
        this.compteRepository.save((Object)client);
        this.agentRepository.save((Object)agent);
        return "retrait r\u00e9ussi";
    }
}

